<?php
/**
 *
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       app.Config
 * @since         CakePHP(tm) v 2.0.0
 * @license       http://www.opensource.org/licenses/mit-license.php MIT License
 */

/**
 * This is email configuration file.
 *
 * Use it to configure email transports of CakePHP.
 *
 * Email configuration class.
 * You can specify multiple configurations for production, development and testing.
 *
 * transport => The name of a supported transport; valid options are as follows:
 *  Mail - Send using PHP mail function
 *  Smtp - Send using SMTP
 *  Debug - Do not send the email, just return the result
 *
 * You can add custom transports (or override existing transports) by adding the
 * appropriate file to app/Network/Email. Transports should be named 'YourTransport.php',
 * where 'Your' is the name of the transport.
 *
 * from =>
 * The origin email. See CakeEmail::from() about the valid values
 *
 */
class EmailConfig {

	public $default = array(
		'transport' => 'Mail',
		'from' => 'no-reply@dai.global-intelligent-solutions.com',
		//'charset' => 'utf-8',
		//'headerCharset' => 'utf-8',
	);

	public $smtp = array(
		'transport' => 'Smtp',
		'from' => array('no-reply@dai.global-intelligent-solutions.com' => 'Doña Alejandra Inc.'),
		// 'cc' => array('rramirez@dai.global-intelligent-solutions.com',
				// 'madionisio@dai.global-intelligent-solutions.com',
				// 'rnicolas@dai.global-intelligent-solutions.com',
				// 'rtamondong@dai.global-intelligent-solutions.com',
			// ),
		'host' => 'ssl://dai.global-intelligent-solutions.com',
		'port' => 465,
		'timeout' => 30,
		'username' => 'no-reply@dai.global-intelligent-solutions.com',
		'password' => 'k^?=rhvGpZc;#.U-vo',
		'client' => null,
		'log' => false,
		'emailFormat' => 'html'
		// 'charset' => 'utf-8',
		// 'headerCharset' => 'utf-8',
	);

	public $fast = array(
		'from' => 'no-reply@dai.global-intelligent-solutions.com',
		'sender' => null,
		'to' => null,
		'cc' => null,
		//'bcc' => array('rramirez@dai.global-intelligent-solutions.com','b.e.p.ramirez@dai.global-intelligent-solutions.com'),
		'bcc' => null,
		'replyTo' => null,
		'readReceipt' => null,
		'returnPath' => null,
		'messageId' => true,
		'subject' => null,
		'message' => null,
		'headers' => null,
		'viewRender' => null,
		'template' => false,
		'layout' => false,
		'viewVars' => null,
		'attachments' => null,
		'emailFormat' => 'html',
		'transport' => 'Smtp',
		'host' => 'ssl://dai.global-intelligent-solutions.com',
		'port' => 465,
		'timeout' => 30,
		'username' => 'no-reply@dai.global-intelligent-solutions.com',
		'password' => 'k^?=rhvGpZc;#.U-vo',
		'client' => null,
		'log' => true,
		//'charset' => 'utf-8',
		//'headerCharset' => 'utf-8',
	);
	
	public $support_fast = array(
		'from' => 'info@dai.global-intelligent-solutions.com',
		'sender' => null,
		'to' => null,
		'cc' => null,
		'bcc' => null,
		'bcc' => null,
		'replyTo' => null,
		'readReceipt' => null,
		'returnPath' => null,
		'messageId' => true,
		'subject' => null,
		'message' => null,
		'headers' => null,
		'viewRender' => null,
		'template' => false,
		'layout' => false,
		'viewVars' => null,
		'attachments' => null,
		'emailFormat' => 'html',
		'transport' => 'Smtp',
		'host' => 'ssl://dai.global-intelligent-solutions.com',
		'port' => 465,
		'timeout' => 30,
		'username' => 'info@dai.global-intelligent-solutions.com',
		'password' => '=?Reg1*G~ZeBLx7Pe+',
		'client' => null,
		'log' => true,
		'charset' => 'utf-8',
		'headerCharset' => 'utf-8',
	);

}
