<?php
/**
 * Routes configuration
 *
 * In this file, you set up routes to your controllers and their actions.
 * Routes are very important mechanism that allows you to freely connect
 * different URLs to chosen controllers and their actions (functions).
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       app.Config
 * @since         CakePHP(tm) v 0.2.9
 * @license       http://www.opensource.org/licenses/mit-license.php MIT License
 */
/**
 * Here, we are connecting '/' (base path) to controller called 'Pages',
 * its action called 'display', and we pass a param to select the view file
 * to use (in this case, /app/View/Pages/home.ctp)...
 */
	Router::connect('/', array('controller' => 'pages', 'action' => 'display', 'home'));
	// Router::connect('/', array('controller' => 'index', 'action' => 'index'));
/**
 * ...and connect the rest of 'Pages' controller's URLs.
 */
	Router::connect('/pages/*', array('controller' => 'pages', 'action' => 'display'));
	
	/* Sitemap Routing */

		Router::connect('/sitemap.xml', array('controller' => 'sitemaps', 'action' => 'sitemap', 'ext' => 'xml'));
		Router::connect('/sitemap', array('controller' => 'sitemaps', 'action' => 'index'));
		Router::redirect('/sitemaps', array('controller' => 'sitemap', 'action' => 'index'));
		
	/* End Sitemap Routing */
	
	/* Start Routing for underscores */
	
		Router::connect('/our-identity/*', array('controller' => 'our_identity', 'action' => 'index'));
		// Router::redirect('/our_identity', array('controller' => 'our-identity', 'action' => 'index'));
		
		Router::connect('/products-and-services/*', array('controller' => 'products_and_services', 'action' => 'index'));
		// Router::redirect('/products_and_services', array('controller' => 'products-and-services', 'action' => 'index'));
	
		Router::connect('/our-team/*', array('controller' => 'our_team', 'action' => 'index'));
		// Router::redirect('/our_team', array('controller' => 'our-team', 'action' => 'index'));
		
		Router::connect('/contact-us', array('controller' => 'contact_us', 'action' => 'index'));
    	Router::connect('/contact-us/:action/*', array('controller' => 'contact_us'));
		
		Router::connect('/support/support-details/*', array('controller' => 'support', 'action' => 'support_details'));
		// Router::redirect('/contact_us', array('controller' => 'contact-us', 'action' => 'index'));
		Router::redirect(
    		'/contact_us/*',
    		array('controller' => 'contact-us'),
    		array('status' => 301)
    	);
	
	/* End Routing for underscores */

/**
 * Load all plugin routes. See the CakePlugin documentation on
 * how to customize the loading of plugin routes.
 */
	CakePlugin::routes();

/**
 * Load the CakePHP default routes. Only remove this if you do not want to use
 * the built-in default routes.
 */
	require CAKE . 'Config' . DS . 'routes.php';
