<?php
class ContactUsController extends AppController {

	public $components = array('Recaptcha.Recaptcha');

	public function index() {
		$this->set('title_for_layout', 'Contact Us | Doña Alejandra, Inc.');
		$this->set('meta_description', 'For inquiries, suggestions and other clarifications, please contact us immediately! We are ready to help! ');
		
		if ($this->request->is('post') || $this->request->is('put')) {
			// $this->ContactUs->set($this->data);
			// if($this->ContactUs->validates()){
				if ($this->Recaptcha->verify()) {
			
					App::uses('CakeEmail', 'Network/Email');
					$email = new CakeEmail();
					$email->config('smtp');
					$email->to("dai.net.ph@gmail.com");
					$email->subject('DAI Contact Form Message' . ' by ' . $this->request->data['ContactUs']['name']);
					$message_body ='
						<h3>Doña Alejandra Incorporated</h3>
						<p><h4>Sender:</h4> ' . $this->request->data['ContactUs']['name'] . '</p>
						<p><h4>Email:</h4> ' . $this->request->data['ContactUs']['email'] . '</p>
						<p><h4>Contact No:</h4> ' . $this->request->data['ContactUs']['contact_number'] . '</p>
						<p><h4>Message:</h4> </p>
						<p>' . $this->request->data['ContactUs']['message'] . '</p>
					';
					
					if($email->send($message_body)) {
						$this->Session->setFlash('Message has been sent.', 'global-notice-success');
						return $this->redirect(array('controller' => 'contact_us'));
					}
					else {
						$this->Session->setFlash('Message has not been sent.', 'global-notice-failed');
					}
				}
				else{
					$this->Session->setFlash('Please solve the captcha before posting.', 'global-notice-failed');
				}
			// }
			
			
		}
		
	}
	
	public function get_jira_status($secret_key = null, $jira_code = null) {
	   if(!$jira_code) {
	        throw new NotFoundException();
	   }
	   
	   if(!$secret_key || $secret_key != 'Rev-dai5ecr3tkey') {
	        throw new NotFoundException();
	   }
	   
	   
	   $this->autoRender = false;
	   $user = 'gyro.deleon@dai-solutions.ph';
	   $pass = 'ATATT3xFfGF0F86YH0_19rN7qzfh8tGg1e1CbzBJwkq9nw5d6Lb40teeUUzHFKzL8-eT4J4ET0ubs2EweAI9IX2GHGIdFNCBBGz1FarMsEL5hmmZ6s3zWZAn-O_SBSrzdqaJ-b4J7tzsWoFNys6T9nOSnCpy3tGRu2xpuHCiciixAnvSdgPbriU=44922443';
	   //$pass = 'ATBBbEY6yytktbEUAcd3hXa2jY6nE4318F3B';
	   $keyCombo = base64_encode($user . ':' . $pass);
	   
	   $target_link = 'https://dai-solutions-ph.atlassian.net/rest/api/2/issue/'. $jira_code .'?fields=status';
	   
	    $ch = curl_init();
	    
        curl_setopt($ch, CURLOPT_URL, $target_link);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Authorization: Basic " . $keyCombo,
            "Content-Type: application/json"
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
        
        $response = curl_exec($ch);
        
	    if (curl_errno($ch)) {
            echo "Error: " . curl_error($ch);
        } else {
            $response = json_decode($response, true);
            if(isset($response['fields']['status']['name']) && !empty($response['fields']['status']['name'])) {
                $this->response->header(array(
                    'Content-type: application/json'
                ));
                return json_encode($response['fields']['status']['name']);
            }
            else {
	            return json_encode('failed');
            }
        }
	   

        curl_close($ch);
	   
	}
	
	public function cron_mailer($key_combination = null){
	    $this->autoRender = false;
	    $this->loadModel('CronHolder');
	    
	    $cc_recipient = array();
	    $bcc_recipient = array();
	    
	    $exclude_date = array(
	        '2019-01-01',
	        '2019-04-09',
	        '2019-04-18',
	        '2019-04-19',
	        '2019-05-13',
	        '2019-06-05',
	        '2019-06-12',
	        '2019-08-12',
	        '2019-08-19',
	        '2019-08-21',
	        '2019-12-24',
	        '2019-12-25',
	        '2019-12-30',
	        '2019-12-31',
	        '2020-01-01',
	        '2020-02-25',
	        '2020-04-09',
	        '2020-04-10',
	        '2020-05-01',
	        '2020-07-31',
	        '2020-08-31',
	        '2020-11-30',
	        '2020-12-08',
	        '2020-12-24',
	        '2020-12-25',
	        '2020-12-30',
	        '2020-12-31',
	        '2021-01-01',
	        '2021-02-12',
	        '2021-02-25',
	        '2021-04-01',
	        '2021-04-02',
	        '2021-04-09',
	        '2021-08-19',
	        '2021-08-30',
	        '2021-11-01',
	        '2021-11-30',
	        '2021-12-08',
	        '2021-12-17', // CHRISTMAS PARTY
	        '2021-12-30',
	        '2022-02-01',
	        '2022-02-25',
	        '2022-05-03',
	        '2022-12-08',
	        '2022-12-16',
	        '2022-12-30',
	        '2023-04-06',
	        '2023-04-07',
	        '2023-04-10',
	        '2023-05-01'
	    );
	    
	    $date_today = date('Y-m-d');
	    
	    if(in_array($date_today, $exclude_date)){
	        return false;
	    }
	    
	    if($key_combination == 'test01'){
	        
    	    $find_latest = $this->CronHolder->find('first', array(
    	        'conditions' => array(
    	            'CronHolder.status' => 'Active',
    	            //'CronHolder.mailing_status' => 'Pending'
    	        ),
    	        'order' => 'CronHolder.last_sent_on ASC'
    	    ));
    	    
    	    $sending_time = date_format(date_create($find_latest['CronHolder']['sending_time']), 'H:i');
    	    $last_sent_date = date_format(date_create($find_latest['CronHolder']['last_sent_on']), 'Y-m-d');
    	    $time_today = date('H:i');
    	    
    	    if(($time_today >= $sending_time) && ($last_sent_date < date('Y-m-d'))){
    	    
        	    if(count($find_latest) > 0){
            	    $recipient_list = json_decode($find_latest['CronHolder']['recipient']);
            	    
            	    App::uses('CakeEmail', 'Network/Email');
            		$email = new CakeEmail();
            		$email->config('support_fast');
    	        
        	        $email->from(array($find_latest['CronHolder']['sender'] => $find_latest['CronHolder']['sender_name']));
            		$email->to($recipient_list);
            	    
            	    if(!empty($find_latest['CronHolder']['cc_recipient'])){
            	        $cc_recipient = json_decode($find_latest['CronHolder']['cc_recipient']);
            	    	$email->cc($cc_recipient);
            	    }
            	    
            	    if(!empty($find_latest['CronHolder']['bcc_recipient'])){
            	        $bcc_recipient = json_decode($find_latest['CronHolder']['bcc_recipient']);
            	    	$email->bcc($bcc_recipient);
            	    }
            	    
            		$email->subject($find_latest['CronHolder']['subject']);
            		
            		$message_body = $find_latest['CronHolder']['content'] . '<p><a href="http://dai.global-intelligent-solutions.com/">dai.global-intelligent-solutions.com</a><br>Ground Floor, ESNA Building #30 Timog Avenue, Quezon City <br>(02) 921-7715</p>';
            	    
            	    $save_array = array();
            	    
            	    $cron_dataSource = $this->CronHolder->getDataSource();
            	    $cron_dataSource->begin();
            	    
        	        //$save_array = $find_latest;
        	        //unset($save_array['CronHolder']['id']);
        	        
        	        $new_sending_time = '';
                    do {
                        $randomized_hour = rand(7,8);
                        
                        if($randomized_hour == 7){
                            $randomized_minute = rand(55,59);
                        }
                        else{
                            $randomized_minute = 0 . rand(1,5);
                        }
            	        $new_sending_time = ''. $randomized_hour .':'. $randomized_minute .':00';
            	        //$save_array['CronHolder']['sending_time'] = $new_sending_time;
                    } while($this->check_sending_time_value($new_sending_time) == true);
        	        
        	        $last_sent_on = "'".date('Y-m-d H:i:s')."'";
        	        $new_sending_time = "'".$new_sending_time."'";
        	        
        	        if($email->send($message_body)){
        	     
    	                 if($this->CronHolder->updateAll(array('CronHolder.last_sent_on' => $last_sent_on, 'CronHolder.sending_time' => $new_sending_time), array('CronHolder.id' => $find_latest['CronHolder']['id']))){     
            	            $cron_dataSource->commit();
            	            
            	            return true;

    	                 }
    	                 else{
                	        $cron_dataSource->rollback();
                	        $cron_dataSource->commit();
                	        
                	        return false;
            	         }
        	        }
                     else{
            	        $cron_dataSource->rollback();
            	        $cron_dataSource->commit();
            	        
            	        return false;
        	         }
            	    
            	    //debug($find_latest);
            	    //debug(date('H:i'));
            	    //debug(date_format(date_create($find_latest['CronHolder']['sending_time']), 'H:i'));
            	    //debug(json_decode($find_latest['CronHolder']['recipient']));
        	    }
        	    else{
        	        return false;
        	    }
    	    }
    	    else{
    	        return false;
    	    }
	    }
	    else{
	        return $this->redirect(array('controller' => 'contact_us', 'action' => 'index'));
	    }
	    
	}
	
	public function check_sending_time_value($sending_time_value = null){
	    $this->loadModel('CronHolder');
	    $find_match = $this->CronHolder->find('count', array(
	        'fields' => array(
	            'CronHolder.id'
	        ),
	        'conditions' => array(
	            'TIME_FORMAT(CronHolder.sending_time, "%H:%i")' => date_format(date_create($sending_time_value), 'H:i'),
	            'CronHolder.mailing_status' => 'Pending',
	            'CronHolder.status' => 'Active'
	        )
	    ));
	    
	    if($find_match > 0){
	        return true;
	    }
	    else{
	        return false;
	    }
	}
	
	public function send_automated_email(){
	    $this->autoRender = false;
	    
	    $email_list[0]['emails'] = array(
	        'armmc.hrmo@gmail.com'    
	    );
	    $email_list[0]['company_name'] = 'ARMMC';
	    
	    $email_list[1]['emails'] = array(
	        'tabytoos@yahoo.com',
            'westernvisayasmedicalcenter.hrmo@yahoo.com',
            'devzzz03@gmail.com'
	    );
	    $email_list[1]['company_name'] = 'WVMC';
	    
	    $email_list[2]['emails'] = array(
	        'mis.clmmrh@gmail.com',
            'clmmrh_hrmo@yahoo.com'
	    );
	    $email_list[2]['company_name'] = 'CLMMRH';
	    
	    $recepient_cc = array(
	        'b.e.p.ramirez@dai.global-intelligent-solutions.com',
            'rramirez@dai.global-intelligent-solutions.com',
            'rtarol@dai.global-intelligent-solutions.com',
            'jacagampan@dai.global-intelligent-solutions.com',
            'hmabalot@dai.global-intelligent-solutions.com',
            'madionisio@dai.global-intelligent-solutions.com',
            'jmbesoyo@dai.global-intelligent-solutions.com',
            'hperez@dai.global-intelligent-solutions.com',
            'gpmingi@dai.global-intelligent-solutions.com',
            'rnicolas@dai.global-intelligent-solutions.com',
            'gdeleon@dai.global-intelligent-solutions.com',
            'rmensurado@dai.global-intelligent-solutions.com',
            'mrtarol@dai.global-intelligent-solutions.com'
	    );
	    
	    
	    App::uses('CakeEmail', 'Network/Email');
		$email = new CakeEmail();
		$email->config('support_fast');
	    
	    foreach($email_list as $email_key => $email_array){
	        
	        $email->from(array('info@dai.global-intelligent-solutions.com' => 'DAI Support'));
    		$email->to($email_array['emails']);
    		$email->cc($recepient_cc);
    		$email->subject('DAI Support For '.$email_array['company_name'].' HRIS');
    		$message_body ='
    		    <p>Good morning, </p>
                <p>Hi '.$email_array['company_name'].' HR, we would like to inform you that the DAI team is ready to provide assistance anytime. If you have encountered any concerns within 24 hours, please send us a support ticket by using our support page at <a href="http://dai.global-intelligent-solutions.com/support">http://dai.global-intelligent-solutions.com/support</a> and a DAI staff will contact you soon.</p>
                <p>
                    Thank you.<br>
                    DAI Team
                </p>
                <p>
                    <a href="http://dai.global-intelligent-solutions.com/">dai.global-intelligent-solutions.com</a><br>
                    Ground Floor, ESNA Building #30 Timog Avenue, Quezon City <br>
                    (02) 921-7715
                </p>
    		';
    	    
    	    $email->send($message_body);
	    }
	    
		return true;
	    
	}


}