<?php
class SupportController  extends AppController {

	public $components = array('Recaptcha.Recaptcha');
	
	public function index() {
		$this->loadModel('SupportProduct');
		$find_products = $this->SupportProduct->find('all', array(
			'order' => 'SupportProduct.id ASC'
		));
		$this->set('find_products', $find_products);
		
		// $this->set('title_for_layout', 'Hardwares | Doña Alejandra, Inc.');
		// $this->set('meta_description', 'Hardwares offered by Doña Alejandra Inc for providing its clients with the best and most effective solutions.');
	}
	
	//public function timezone(){
	//    $this->autoRender = false;
	//    debug(date('Y-m-d H:i:s A'));
	//}
	
	public function support_details($slug = null) {
		$this->loadModel('SupportConcern');
		$this->loadModel('SupportProduct');
		$this->loadModel('SupportConcernType');
		$find_product = $this->SupportProduct->findBySlug($slug);
		if(count($find_product) > 0){
			
			$concern_type = $this->SupportConcernType->find('list', array(
				'fields' => array(
					'SupportConcernType.code',
					'SupportConcernType.name'
				),
				'conditions' => array(
					'SupportConcernType.status' => 'Active'
				),
				'order' => 'SupportConcernType.name ASC'
			));
			$this->set('concern_type', $concern_type);
			$this->set('find_product', $find_product);
			
			if($this->request->is('post') || $this->request->is('put')){
				
				if($this->Recaptcha->verify()){
				    $this->request->data['SupportConcern']['product_code'] = $find_product['SupportProduct']['code'];
			        $this->request->data['SupportConcern']['ip_address'] = $this->request->clientIp();
    				
    				$attachments = array();
    				
    				foreach($this->request->data['Attachment'] as $concern_key => $concern_key_value){
    					if($concern_key_value['size'] > 0){
    						$file_path = "files". "/" ."ticket_attachments";
    						
    						$temp = explode(".", $concern_key_value["name"]);
    						$newfilename = uniqid().rand(0,99) . '.' . end($temp);
    						if (!file_exists($file_path)) {
    							mkdir($file_path, 0777, true);
    						}
    						move_uploaded_file($this->request->data['Attachment'][$concern_key]["tmp_name"], $file_path. "/" . $newfilename );
    						
    						$attachments[$concern_key . '.' . end($temp)] = $file_path. "/" . $newfilename;
    					}
    				}
    				
    				unset($this->request->data['Attachment']);
    				
    				$update_reference = true;
    				if(!isset($this->request->data['SupportConcern']['ticket_number'])){
    					$this->loadModel('ReferenceCode');
    			
    					$code_char = 'TN';
    					$reference = $this->ReferenceCode->findByPrefixCode($code_char);
    					$code_number = $reference['ReferenceCode']['number'] + 1;
    					$year = $reference['ReferenceCode']['year_code'];
    					
    					if($year != date('Y')){
    						$year= date('Y');
    						$this->ReferenceCode->query("UPDATE setting_reference_codes SET year_code = '$year' WHERE prefix_code = '$code_char'");
    						$code_number=1;
    					}
    					$this->request->data['SupportConcern']['ticket_number'] = (date('y') . '-'.$code_char . (str_pad($code_number,7,"0",STR_PAD_LEFT)));
    				}
    				else{
    					$find_ticket = $this->SupportConcern->findByTicketNumber($this->request->data['SupportConcern']['ticket_number']);
    					if(count($find_ticket) <= 0 ){
    						$this->Session->setFlash('The ticket number you specified is not in our list.', 'global-notice-failed');
    						return $this->redirect(array('controller' => 'support', 'action' => 'index'));
    					}
    					else{
    					    $update_reference = false;
    					}
    				}
    			
    				if(!empty($this->request->data['SupportConcern']['concern_type_code'])){
    					$find_concern_type_detail = $this->SupportConcernType->findByCode($this->request->data['SupportConcern']['concern_type_code']);
    				}
    				else{
    					$this->Session->setFlash('The concern type you entered was invalid.', 'global-notice-failed');
    					return $this->redirect(array('controller' => 'support', 'action' => 'index'));
    				}
    				
    				$support_subject = '';
    				$date = date_create($this->request->data['SupportConcern']['date']);
    				$this->request->data['SupportConcern']['date'] = date_format($date,"Y-m-d");
    				$formatted_time = $this->request->data['SupportConcern']['time'];
    				$this->request->data['SupportConcern']['time'] = date("H:i", strtotime($this->request->data['SupportConcern']['time']));
    				
    				if(!empty($this->request->data['SupportConcern']['support_type']) && $this->request->data['SupportConcern']['support_type'] == 'New Support'){
    				    $support_subject = 'TICKET ID ['.$this->request->data['SupportConcern']['ticket_number'].'] ' . $find_product['SupportProduct']['product_name'] . ' Support Request';
    				}
    				else if(!empty($this->request->data['SupportConcern']['support_type']) && $this->request->data['SupportConcern']['support_type'] == 'Follow-up Support'){
    				    $support_subject = 'Follow-up Support Request of TICKET ID ['.$this->request->data['SupportConcern']['ticket_number'].'] ';
    				}
    				else{
    					$this->Session->setFlash('The support type you selected was invalid.', 'global-notice-failed');
    					return $this->redirect(array('controller' => 'support', 'action' => 'index'));
    				}
    				
    				// $email_list = array('support@dai.global-intelligent-solutions.com', 'rramirez@dai.global-intelligent-solutions.com', 'madionisio@dai.global-intelligent-solutions.com', 'rnicolas@dai.global-intelligent-solutions.com', 'gdeleon@dai.global-intelligent-solutions.com', 'rtamondong@dai.global-intelligent-solutions.com', 'jmbesoyo@dai.global-intelligent-solutions.com', 'rmensurado@dai.global-intelligent-solutions.com', 'pnanzan@dai.global-intelligent-solutions.com', 'gpmingi@dai.global-intelligent-solutions.com', 'lasillano@dai.global-intelligent-solutions.com', 'edelossantos@dai.global-intelligent-solutions.com', 'hperez@dai.global-intelligent-solutions.com', 'jacagampan@dai.global-intelligent-solutions.com', 'mrtarol@dai.global-intelligent-solutions.com');
    				$email_list = array(
                    	'support@dai.global-intelligent-solutions.com', 
                    	'king.ramirez@dai-solutions.ph', 
                    	'arvin.dionisio@dai-solutions.ph', 
                    	'dhel.nicolas@dai-solutions.ph', 
                    	'gyro.deleon@dai-solutions.ph', 
                    	'jm.besoyo@dai-solutions.ph',
                    	'angela.linquico@dai-solutions.ph',
                    	'harvey.perez@dai-solutions.ph', 
                    	'judd.cagampan@dai-solutions.ph', 
                    	'mark.tarol@dai-solutions.ph',
                    	'lovie.abaya@dai-solutions.ph',
                    	'denden.lescain@dai-solutions.ph',
                    	'cristine.stamaria@dai-solutions.ph',
                    	'support@dai-solutions.ph',
                    	'raymart.tamondong@dai-solutions.ph'
                    );
    				// debug($this->request->data);
    				// exit();
    				App::uses('CakeEmail', 'Network/Email');
    				$email = new CakeEmail();
    				$email->template('internal-email-template', 'email-template-header');
    				$email->config('smtp');
    				$email->viewVars(array('request_data' => $this->request->data, 'find_product' => $find_product, 'find_concern_type_detail' => $find_concern_type_detail));
    				
    				
    				foreach($email_list as $list){
    				    $email->addTo($email_list);
    				}
    				
    				$email->subject($support_subject);
    				$email->attachments($attachments);
    				
    				$copy_email = new CakeEmail();
    				$copy_email->template('email-template', 'email-template-header');
    				$copy_email->config('smtp');
    				$copy_email->viewVars(array('request_data' => $this->request->data, 'find_product' => $find_product, 'find_concern_type_detail' => $find_concern_type_detail));
    				$copy_email->to(trim($this->request->data['SupportConcern']['email_address']));
    				$copy_email->subject($support_subject);
    				$copy_email->attachments($attachments);
    				
    				if($this->SupportConcern->save($this->request->data)) {
    					
    					if($email->send() && $copy_email->send()){
    					    
        					if($update_reference == true){
        				    	$this->ReferenceCode->query("UPDATE setting_reference_codes SET number = '$code_number' WHERE prefix_code = '$code_char'");
        					}
        					
        					foreach($attachments as $attachment_key_value){
        						$file_to_delete = new File($attachment_key_value, false, 0777);
        						$file_to_delete->delete();
        					}
        					$this->Session->setFlash('Message has been sent.', 'global-notice-success');
        					return $this->redirect(array('controller' => 'support', 'action' => 'index'));
    					}
    					else{
    					    $this->Session->setFlash('Message has not been sent.', 'global-notice-failed');
    					}
    				}
    				else {
    				    unset($this->request->data['SupportConcern']['ticket_number']);
    					$this->Session->setFlash('Message has not been sent.', 'global-notice-failed');
    				}
				}
				else{
				    $this->Session->setFlash('Please solve the captcha before sending the request.', 'global-notice-failed');
				}
				
			}
			
		}
		else{
			$this->Session->setFlash('Please select from our list supported categories.', 'global-notice-failed');
			return $this->redirect(array('controller' => 'support', 'action' => 'index'));
		}
	}
	
}