<?php

$cakeDescription = __d('cake_dev', 'Doña Alejandra, Inc.');
$metaDescription = __d('cake_dev', 'The leading Document Management System, hardware provider and customized software developer in the Philippines using the practices to provide effective solutions and reduced operation costs!');

	if (empty($title_for_layout)) {
		$title_for_layout = $cakeDescription;
	}
	else {
		$title_for_layout;
	}

	if (empty($meta_description)) {
		$meta_description = $metaDescription;
	}
	else {
		$meta_description;
	}

?>
<!DOCTYPE html>
<html lang="en">
<head><meta http-equiv="Content-Type" content="text/html; charset=euc-jp">
	<?php echo $this->Html->charset(); ?>
	<title>
		<?php echo $title_for_layout ?>
	</title>
	<meta name="description" content="<?php echo $meta_description ?>">
	<meta content='System Integration, Document Management System, Hospital Systems, IT Solution Philippines' name='keywords'/>
	<meta name="developer" content="Gyro De Leon" />
	<?php
		echo $this->Html->meta('favicon.ico', $this->Html->url('/favicon.ico'), array('type' => 'icon'));
		/* echo $this->Html->meta('icon'); */
		echo $this->Html->css('http://fonts.googleapis.com/css?family=Lato:300,400,700,900');
		echo $this->Html->css('normalize');
		echo $this->Html->css('bootstrap');
		echo $this->Html->css('settings');
		echo $this->Html->css('font-awesome');
		echo $this->Html->css('dai');
		echo $this->Html->script('https://ajax.googleapis.com/ajax/libs/jquery/1.12.0/jquery.min.js');
		echo $this->Html->script('bootstrap.js');
		echo $this->Html->script('http://cdnjs.cloudflare.com/ajax/libs/mousetrap/1.4.6/mousetrap.min.js');
		echo $this->Html->script('jquery.themepunch.tools.min');
		echo $this->Html->script('jquery.themepunch.revolution.min');
		/* echo $this->Html->script('https://cdn.jsdelivr.net/scrollreveal.js/3.1.4/scrollreveal.min.js'); */

		echo $this->fetch('meta');
		echo $this->fetch('css');
		echo $this->fetch('script');
	?>
	<script>
	  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
	  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
	  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
	  })(window,document,'script','https://www.google-analytics.com/analytics.js','ga');
	
	  ga('create', 'UA-87766289-1', 'auto');
	  ga('send', 'pageview');
	
	</script>
	
	<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=0.5, maximum-scale=1.5, user-scalable=yes">
</head>


	<script>
		function returnHome() {
			window.location.href = '<?php echo $this->Html->url(array('controller' => 'pages', 'action' => 'display')); ?>'; 
		}
		
		function returnIdentity() {
			window.location.href = '<?php echo $this->Html->url(array('controller' => 'our_identity', 'action' => 'index')); ?>'; 
		}
		
		function returnProductsandServices() {
			window.location.href = '<?php echo $this->Html->url(array('controller' => 'products_and_services', 'action' => 'index')); ?>'; 
		}
		
		function returnTeam() {
			window.location.href = '<?php echo $this->Html->url(array('controller' => 'our_team', 'action' => 'index')); ?>'; 
		}
		
		function returnContact() {
			window.location.href = '<?php echo $this->Html->url(array('controller' => 'contact_us', 'action' => 'index')); ?>'; 
		}
		
		function returnSitemap() {
			window.location.href = '<?php echo $this->Html->url(array('controller' => 'sitemap', 'action' => 'index')); ?>'; 
		}
		
		Mousetrap.bind(['command+1', 'alt+1', 'ctrl+alt+1'], returnHome);
		Mousetrap.bind(['command+2', 'alt+2', 'ctrl+alt+2'], returnIdentity);
		Mousetrap.bind(['command+3', 'alt+3', 'ctrl+alt+3'], returnProductsandServices);
		Mousetrap.bind(['command+4', 'alt+4', 'ctrl+alt+4'], returnTeam);
		Mousetrap.bind(['command+5', 'alt+5', 'ctrl+alt+5'], returnContact);
		Mousetrap.bind(['command+s', 'alt+s'], returnSitemap);
		
		Mousetrap.bind('?', function() {
			$('#help').modal('show');
		});
	</script>
	
	

<body>
<div id="container">
<header class="clearfix">
	<nav class="navbar navbar-default navbar-fixed-top" role="navigation" itemscope itemtype="http://schema.org/SiteNavigationElement">
		<div class="container">
			<!-- Brand and toggle get grouped for better mobile display -->
			<div class="navbar-header">
				<button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
					<span class="sr-only">Toggle navigation</span>
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
				</button>
				<a class="navbar-brand" href="<?php echo $this->Html->url(array('controller' => 'pages', 'action' => 'display')); ?>">
					<img src="<?php echo Router::url('/', true); ?>img/dai-favicon.png" class="visible-xs img-header">
					<img src="<?php echo Router::url('/', true); ?>img/dai_nav_transparent.png" alt="" class="hidden-xs img-header">
				</a>
			</div>

			<!-- Collect the nav links, forms, and other content for toggling -->
			<div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
				<ul class="nav navbar-nav navbar-right navigate-section">
					<li class="drop"><a href="<?php echo $this->Html->url(array('controller' => 'our_identity', 'action' => 'index')); ?>" itemprop="url">OUR IDENTITY</a></li>
					<li class="drop"><a href="<?php echo $this->Html->url(array('controller' => 'clients', 'action' => 'index')); ?>" itemprop="url">CLIENTS</a></li>
					<li class="drop"><a href="<?php echo $this->Html->url(array('controller' => 'products_and_services', 'action' => 'index')); ?>" itemprop="url">PRODUCTS & SERVICES</a></li>
					<li class="drop">
					<a class="dropdown-toggle" data-toggle="dropdown" href="#">BROCHURES
						<span class="caret"></span></a>
						<ul class="dropdown-menu">
						  <li><a href="<?php echo $this->Html->url(array('controller' => 'softwares', 'action' => 'index')); ?>">SOFTWARES</a></li>
						  <li><a href="<?php echo $this->Html->url(array('controller' => 'hardwares', 'action' => 'index')); ?>">HARDWARE</a></li>
						</ul>
					</li>
					<li class="drop"><a href="<?php echo $this->Html->url(array('controller' => 'contact_us', 'action' => 'index')); ?>" itemprop="url">CONTACT</a></li>
					<li class="drop"><a href="<?php echo $this->Html->url(array('controller' => 'support', 'action' => 'index')); ?>" itemprop="url">SUPPORT</a></li>
					
					
				</ul>
			</div><!-- /.navbar-collapse -->
		</div><!-- /.container-fluid -->
	</nav>
	
	
	
</header>



		
		
		<br/>
		<br/>
		<div id="content">

			<?php echo $this->Session->flash(); ?>

			<?php echo $this->fetch('content'); ?>
			
		</div>
		
		
	</div>	
	<div class="footer container-fluid no-margin no-padding">
		<div class="container">
			<div class="row" itemscope itemtype="http://schema.org/SiteNavigationElement">
				<div class="col-xs-6 col-md-2">
					<center><a href ="<?php echo $this->Html->url(array('controller' => 'pages', 'action' => 'display')); ?>" itemprop="url">
						<!-- <img src="img/dai-favicon.png" class="visible-xs img-responsive dai-icon-footer"> -->
						<ul>
							<?php 
								echo $this->Html->image("white-logo.PNG", array(
								'title' => "Doña Alejandra Inc.",
								'class' => "dai-logo-footer",
								'alt' => "Doña Alejandra Inc."
								));
							?>
						</ul></a>
					</center>
				</div>
				<div class="col-xs-6 col-md-10 footer-navigation">
					<div class="col-md-4">
						<strong><h5>QUICK LINKS</h5></strong>
						<ul class="list-style">
							<li class="list-style"><i class="fa fa-angle-right"></i><a href="<?php echo $this->Html->url(array('controller' => 'our_identity', 'action' => 'index')); ?>" class="footer-link" itemprop="url"> Our Identity</a></li>
							<li class="list-style"><i class="fa fa-angle-right"></i><a href="<?php echo $this->Html->url(array('controller' => 'clients', 'action' => 'index')); ?>" class="footer-link" itemprop="url"> Clients</a></li>
							<li class="list-style"><a href="<?php echo $this->Html->url(array('controller' => 'products_and_services', 'action' => 'index')); ?>" class="footer-link" itemprop="url"><i class="fa fa-angle-right"></i> Products and Services</a></li>
						</ul>
					</div>
					<div class="col-md-3 footer-middle-col">
						<ul class="list-style">
							<li><a href="<?php echo $this->Html->url(array('controller' => 'contact_us', 'action' => 'index')); ?>" class="footer-link" itemprop="url"><i class="fa fa-angle-right"></i> Contact Us</a></li>
							<li><a href="<?php echo $this->Html->url(array('controller' => 'support', 'action' => 'index')); ?>" class="footer-link" itemprop="url"><i class="fa fa-angle-right"></i> Support</a></li>
							<li><a href="<?php echo $this->Html->url(array('controller' => 'sitemap', 'action' => 'index')); ?>" class="footer-link" itemprop="url"><i class="fa fa-angle-right"></i> Sitemap</a></li>
						</ul>
					</div>
					<div class="col-md-5">
					<strong><h5>CONTACT US</h5></strong>
						<address class="address-text">
							#30 Timog Avenue<br/>
							Ground Floor ESNA Building, Quezon City<br/>
							<span class="enlarged-text">+632 8 921 7715</span><br/>
							info@dai.global-intelligent-solutions.com
						<h4>
							<!-- <i class="fa fa-facebook-square"></i>
							<i class="fa fa-twitter-square"></i>
							<i class="fa fa-google-plus-square"></i> -->
						</h4>
						</address>
					</div>
				</div>
			</div>
			<hr/>
			<div class="row copyright text-center">
				Copyright &copy; Doña Alejandra Incorporated. 2016. All rights Reserved
			</div>
		</div>
	</div>	
		<!-- Keyboard Shortcut -->
					  <div class="modal fade" id="help" role="dialog">
						<div class="modal-dialog modal-md">
						  <div class="modal-content">
							<div class="modal-header">
							  <button type="button" class="close" data-dismiss="modal">&times;</button>
							  <h4 class="modal-title">Keyboard Shortcuts</h4>
							</div>
							<div class="modal-body">
								<ul class="list-style">
									  <li><kbd><kbd>alt</kbd> + <kbd>1</kbd></kbd> - Go to <b>Home</b> Page </li>
									  <li><kbd><kbd>alt</kbd> + <kbd>2</kbd></kbd> - Go to <b>Our Identity</b> Page </li>
									  <li><kbd><kbd>alt</kbd> + <kbd>3</kbd></kbd> - Go to <b>Products and Services</b> Page </li>
									  <li><kbd><kbd>alt</kbd> + <kbd>4</kbd></kbd> - Go to <b>Our Team</b> Page </li>
									  <li><kbd><kbd>alt</kbd> + <kbd>5</kbd></kbd> - Go to <b>Contact Us</b> Page </li>
									  <li><kbd><kbd>alt</kbd> + <kbd>s</kbd></kbd> - Go to <b>Sitemap</b> Page </li>
									<br/>
									<li><kbd>?</kbd> - Show Help Modal </li>
								</ul>
							</div>
						  </div>
						</div>
					  </div>
		<!-- Keyboard Shortcut -->
<script>
	$(document).ready(function(){
	  $('.dropdown-submenu a.submenus').on("click", function(e){
		$(this).next('ul').toggle();
		e.stopPropagation();
		e.preventDefault();
	  });
	});
</script>			  
</body>
</html>