<?php
	if(!empty($find_product['SupportProduct']['image_banner'])){
		$image_banner = $find_product['SupportProduct']['image_banner'];
	}
	else{
		$image_banner = 'img/support_background.png';
	}
	
	echo $this->Html->css('datepicker3');
	echo $this->Html->script('bootstrap-datepicker');
	echo $this->Html->css('clockpicker');
	echo $this->Html->script('clockpicker');
?>
<div class="container-fluid slim-banner no-margin no-padding">
	<div class="row no-padding no-margin">
		<div class="col-md-12 no-padding no-margin">
			<img src="<?php echo Router::url('/', true) . $image_banner;?>" class="img-responsive" alt="Support" itemprop="image" />
			<div class="container-caption">
				<h1><b><?php echo $find_product['SupportProduct']['product_name']; ?></b></h1>
			</div> 
		</div>
	</div>
</div>


<div class="container contact-details">

	<div class="row no-margin no-padding container-padding">
		<?php echo $this->Session->flash(); ?>
		<?php 
			echo $this->Form->create('SupportConcern', array('enctype'=>'multipart/form-data'));
		?>
		
		<div class="col-md-5 form-input form-padding padding-right-40">	
			<h2 class="header-text"><span class="text-red">CLIENT</span> DETAILS</h2>
			<h4>We'll be needing the following:</h4>
			<br/>
			
			<?php 
				
				echo '
					<div class="form-group">
					  <label for="CompanyName">Company Name <span class="text-red">*</span></label>
					  '.
						$this->Form->input('company_name',
							array(
								'type' => 'text',
								'id' => 'CompanyName',
								'placeholder' => 'Company Name',
								'class' => 'form-control',
								'required',
								'label' => false
							)
						)
					  .'
					</div>
					<div class="form-group">
					  <label for="CompanyAddress">Company Address <span class="text-red">*</span></label>
					  '.
						$this->Form->input('company_address',
							array(
								'type' => 'text',
								'id' => 'CompanyAddress',
								'placeholder' => 'Company Address',
								'class' => 'form-control',
								'required',
								'label' => false
							)
						)
					  .'
					</div>
					<div class="form-group">
					  <label for="ContactName">Contact Name <span class="text-red">*</span></label>
					  '.
						$this->Form->input('contact_name',
							array(
								'type' => 'text',
								'id' => 'ContactName',
								'placeholder' => 'Contact Name',
								'class' => 'form-control',
								'required',
								'label' => false
							)
						)
					  .'
					</div>
					<div class="form-group">
					  <label for="ContactNumber">Contact Number <span class="text-red">*</span></label>
					  '.
						$this->Form->input('contact_number',
							array(
								'type' => 'text',
								'id' => 'ContactNumber',
								'placeholder' => 'Contact Number',
								'class' => 'form-control',
								'required',
								'label' => false
							)
						)
					  .'
					</div>
					<div class="form-group">
					  <label for="Email">Email <span class="text-red">*</span></label>
					  '.
						$this->Form->input('email_address',
							array(
								'type' => 'text',
								'id' => 'Email',
								'placeholder' => 'E-mail',
								'class' => 'form-control',
								'required',
								'label' => false
							)
						)
					  .'
					</div>
					
					
				';
			?>
			
				<br/>
				<p>
					<i>Tickets are auto-generated unless you're making a follow-up request.</i>
					
					<hr>
					All details are kept private including the e-mail address you provide. 
					<h4>Don't worry, we don't SPAM.</h4>
					<br/>
					<!-- <center>
						<img src="<?php echo Router::url('/', true); ?>img/no_spam.png" class="img-responsive" alt="Support" itemprop="image" />
					</center> -->
				</p>
		</div>
		
		<div class="col-md-7 form-input form-padding padding-right-40">
			<h2 class="header-text">SUPPORT <span class="text-red">TICKET</span></h2>
			<h4>What kind of support are you looking for?</h4>
			
			<br/>
			<?php 
				
				echo '
					<div class="form-group">
					  <label for="SupportType">Support Type <span class="text-red">*</span></label>
					  '.
						$this->Form->input('support_type',
							array(
								// 'type' => 'text',
								'id' => 'support_type',
								'options' => array(
									'New Support' => 'New Support Request',
									'Follow-up Support' => 'Follow-Up Support Request',
								),
								'empty' => '(Please select)',
								'class' => 'form-control',
								'required',
								'label' => false
							)
						)
					  .'
					</div>
					<div class="form-group">
					  <label for="TicketNumber">Ticket Number</label>
					  '.
						$this->Form->input('ticket_number',
							array(
								'type' => 'text',
								'id' => 'TicketNumber',
								'placeholder' => 'Ticket Number',
								'disabled',
								'class' => 'form-control',
								'label' => false
							)
						)
					  .'
					</div>
					<div class="form-group">
					  <label for="ConcernType">Concern Type <span class="text-red">*</span></label>
					  '.
						$this->Form->input('concern_type_code',
							array(
								// 'type' => 'text',
								'id' => 'concern_type',
								'options' => $concern_type,
								'empty' => '(Please select)',
								'class' => 'form-control',
								'required',
								'label' => false
							)
						)
					  .'
					</div>
					<div class="form-group">
					  <label for="DateTime">When did it occur? <span class="text-red">*</span></label>
					  <div class="row">
						<div class="col-xs-6">
							'.
								$this->Form->input('date',
									array(
										'type' => 'text',
										'id' => 'date',
										'placeholder' => 'When did this happen? ( Date )',
										'class' => 'form-control date',
										'required',
										'label' => false
									)
								)
							  .'
						  </div>
						  <div class="col-xs-6">
							'.
								$this->Form->input('time',
									array(
										'type' => 'text',
										'id' => 'time',
										'placeholder' => 'What time? ( Time )',
										'class' => 'form-control clockpicker',
										'label' => false
									)
								)
							  .'
						  </div>
					  </div>
					</div>
					<div class="form-group">
					  <label for="Details">Details <span class="text-red">*</span></label>
					  '.
						$this->Form->input('details',
							array(
								'type' => 'textarea',
								'rows' => 4,
								'id' => 'message',
								'placeholder' => 'Please place your concern here.',
								'class' => 'form-control',
								'required',
								'label' => false
							)
						)
					  .'
					</div>
					<hr>
					<label for="Attachments">Attachments</label>
					<div class="form-group">
					  '.
						$this->Form->input('Attachment.first_attachment',
							array(
								'type' => 'file',
								'accept'=> array('image/*, application/pdf'),
								'id' => 'FirstAttachment',
								'class' => 'form-control',
								'label' => false
							)
						)
					  .'
					</div>
					<div class="form-group">
					  '.
						$this->Form->input('Attachment.second_attachment',
							array(
								'type' => 'file',
								'accept'=> array('image/*, application/pdf'),
								'id' => 'SecondAttachment',
								'class' => 'form-control',
								'label' => false
							)
						)
					  .'
					</div>
					<div class="form-group">
					  '.
						$this->Form->input('Attachment.third_attachment',
							array(
								'type' => 'file',
								'accept'=> array('image/*, application/pdf'),
								'id' => 'ThirdAttachment',
								'class' => 'form-control',
								'label' => false
							)
						)
					  .'
					</div>
					<br/>
					<div class="form-group">
						<div style="transform:scale(0.77);-webkit-transform:scale(0.77);transform-origin:0 0;-webkit-transform-origin:0 0;"> 
					';
				?>
				
				  
						<?php 
							echo $this->Recaptcha->display(array(
    							'recaptchaOptions' => array(
    							    'theme' => 'light'
    							)
							)); 
						?>
						</div>
						<button type="submit" class="btn red-button pull-right">Send</button>
					</div>
				<br/>
		</div>

		<?php
			echo $this->Form->end();	
		?>
	</div>
</div>
<script>

	$(document).ready(function(){
		
		$('#date').datepicker({
			todayBtn: "linked",
			keyboardNavigation: false,
			forceParse: false,
			calendarWeeks: true,
			autoclose: true
		});

		$('.clockpicker').clockpicker({
			// placement: 'bottom',
			align: 'left',
			autoclose: true,
			vibrate: true,
			twelvehour: true,
			'default': 'now'
		});
		
		$("#support_type").change(function(){
			if($(this).val() == 'Follow-up Support'){
				$("#TicketNumber").removeAttr('disabled');
				$("#TicketNumber").attr('required', 'required');
			}
			else{
				$("#TicketNumber").attr('disabled', 'disabled');
				$("#TicketNumber").removeAttr('required');
			}
		});
	});

</script>